/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.dlic.auth.http.saml;

import com.floragunn.dlic.auth.http.saml.HTTPSamlAuthenticator;
import com.floragunn.dlic.util.SettingsBasedSSLConfigurator;
import java.nio.file.Path;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.resolver.ResolverException;
import net.shibboleth.utilities.java.support.xml.BasicParserPool;
import net.shibboleth.utilities.java.support.xml.ParserPool;
import org.apache.http.client.HttpClient;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.elasticsearch.SpecialPermission;
import org.elasticsearch.common.settings.Settings;
import org.opensaml.saml.metadata.resolver.impl.HTTPMetadataResolver;

@Deprecated
public class SamlHTTPMetadataResolver
extends HTTPMetadataResolver {
    private static int componentIdCounter = 0;

    SamlHTTPMetadataResolver(Settings esSettings, Path configPath) throws ResolverException, SettingsBasedSSLConfigurator.SSLConfigException, ComponentInitializationException {
        super(SamlHTTPMetadataResolver.createHttpClient(esSettings, configPath), esSettings.get("idp.metadata_url"));
        this.setId(HTTPSamlAuthenticator.class.getName() + "_" + ++componentIdCounter);
        this.setRequireValidMetadata(true);
        this.setFailFastInitialization(false);
        this.setMinRefreshDelay(Duration.of(esSettings.getAsLong("idp.min_refresh_delay", Long.valueOf(60000L)), ChronoUnit.MILLIS));
        this.setMaxRefreshDelay(Duration.of(esSettings.getAsLong("idp.max_refresh_delay", Long.valueOf(14400000L)), ChronoUnit.MILLIS));
        this.setRefreshDelayFactor(esSettings.getAsFloat("idp.refresh_delay_factor", Float.valueOf(0.75f)).floatValue());
        BasicParserPool basicParserPool = new BasicParserPool();
        basicParserPool.initialize();
        this.setParserPool((ParserPool)basicParserPool);
    }

    protected byte[] fetchMetadata() throws ResolverException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<byte[]>(){

                @Override
                public byte[] run() throws ResolverException {
                    return SamlHTTPMetadataResolver.super.fetchMetadata();
                }
            });
        }
        catch (PrivilegedActionException e) {
            if (e.getCause() instanceof ResolverException) {
                throw (ResolverException)e.getCause();
            }
            throw new RuntimeException(e);
        }
    }

    private static SettingsBasedSSLConfigurator.SSLConfig getSSLConfig(Settings settings, Path configPath) throws SettingsBasedSSLConfigurator.SSLConfigException {
        return new SettingsBasedSSLConfigurator(settings, configPath, "idp").buildSSLConfig();
    }

    private static HttpClient createHttpClient(final Settings settings, final Path configPath) throws SettingsBasedSSLConfigurator.SSLConfigException {
        try {
            SecurityManager sm = System.getSecurityManager();
            if (sm != null) {
                sm.checkPermission((Permission)new SpecialPermission());
            }
            return AccessController.doPrivileged(new PrivilegedExceptionAction<HttpClient>(){

                @Override
                public HttpClient run() throws Exception {
                    return SamlHTTPMetadataResolver.createHttpClient0(settings, configPath);
                }
            });
        }
        catch (PrivilegedActionException e) {
            if (e.getCause() instanceof SettingsBasedSSLConfigurator.SSLConfigException) {
                throw (SettingsBasedSSLConfigurator.SSLConfigException)e.getCause();
            }
            throw new RuntimeException(e);
        }
    }

    private static HttpClient createHttpClient0(Settings settings, Path configPath) throws SettingsBasedSSLConfigurator.SSLConfigException {
        HttpClientBuilder builder = HttpClients.custom();
        builder.useSystemProperties();
        SettingsBasedSSLConfigurator.SSLConfig sslConfig = SamlHTTPMetadataResolver.getSSLConfig(settings, configPath);
        if (sslConfig != null) {
            builder.setSSLSocketFactory((LayeredConnectionSocketFactory)sslConfig.toSSLConnectionSocketFactory());
        }
        return builder.build();
    }
}

